-- V2D - 12549 Messaging for APPLICATION_RE_ASSIGN Event

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'Application Re-Assign Applicant');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='Application Re-Assign Applicant');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'APPLICATION_RE_ASSIGN_APPLICANT', 'APPLICATION_RE_ASSIGN_APPLICANT', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Application Re-Assign Applicant');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1  , @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1  , @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_RE_ASSIGN_APPLICANT_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_RE_ASSIGN_APPLICANT_RECIPIENT', 'SQL');

-- SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
-- INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BULK_DOCUMENT_DOWNLOAD_TDP', 'CB');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_RE_ASSIGN_APPLICANT_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICATION_RE_ASSIGN_APPLICANT_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_RE_ASSIGN_APPLICANT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_RE_ASSIGN_APPLICANT_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);


-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_RE_ASSIGN_APPLICANT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID FROM application T1 WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_RE_ASSIGN_APPLICANT_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T3.`id` AS ID,    
    T4.`firstName` AS FIRST_NAME,
    T4.`middleName` AS MIDDLE_NAME,
    T4.`lastName` AS LAST_NAME,    
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T4.`mobileCountryCode` AS MOBILE_CODE,
    T3.`code` AS APPLICATION_CODE,
    T8.`displayName` AS ACADEMY_NAME_LOCATION,
    T8.`academyName` AS ACADEMY_NAME,
    T8.`locationName` AS LOCATION_NAME,
    T12.`programNameToBePrint` AS PROGRAM_NAME,
    T10.`printName` AS BATCH_PRINT_NAME,
    T18.`seatName` AS SEAT_TYPE,
    T19.`firstName` AS APPLICATION_OWNER_FIRST_NAME,
    T19.`lastName` AS APPLICATION_OWNER_LAST_NAME,
    T19.`emailId` AS APPLICATION_OWNER_EMAIL,
    T21.`mobileNumber` AS APPLICATION_OWNER_MOBILE_NO,
    T21.`mobileCountryCode` AS APPLICATION_OWNER_MOBILE_CODE,
    DATE_FORMAT(T3.`applicationAssignDate`, '%d-%m-%Y') AS APPLICATION_RE_ASSIGN_DATE,
    T3.`applicationAssignRemark` AS APPLICATION_RE_ASSIGN_REMARK,
    (CASE
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'APPLIED'
        THEN
            'Applied'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'NOT_APPLIED'
        THEN
            'Not Applied'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'SOLD'
        THEN
            'Sold'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'SUBMITTED'
        THEN
            'Submitted'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'DIRECT_ADMISSION'
        THEN
            'Direct Admission'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'MID_TERM_ADMISSION'
        THEN
            'Mid term admission'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
        THEN
            'Direct submission token generated'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
        THEN
            'Form sale token generated'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'NOT_SUBMITTED'
        THEN
            'Not Submitted'
        WHEN
            T3.currentStatus IS NOT NULL
                AND T3.currentStatus = 'ADMISSION_GRANTED'
        THEN
            'Admission granted'
        ELSE ''
    END) AS APPLICATION_STATUS,
    (CASE
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_ACCEPTED'
        THEN
            'Offer letter accepted'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_ISSUED'
        THEN
            'Offer letter issued'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_REJECTED'
        THEN
            'Offer letter rejected'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_DUE'
        THEN
            'Offer letter due'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ACTIVE'
        THEN
            'Active'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ADMITTED'
        THEN
            'Admitted'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ADMITTED_ON_TRIAL'
        THEN
            'Admitted on trial'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ADMITTED_ON_PROVISIONAL'
        THEN
            'Admitted on provisional'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
        THEN
            'Withdrawn after accepting offer letter'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
        THEN
            'Provisional offer issued'
            WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
        THEN
            'Provisional offer rejected'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_DUE'
        THEN
            'Provisional offer due'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_EXPIRED'
        THEN
            'Offer Expired'
            WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
        THEN
            'Provisional Offer Expired'
        ELSE ''
    END) AS OFFER_STATUS,
    DATE_FORMAT(T3.`applicationCreatedOn`, '%d-%m-%Y') AS APPLICATION_DATE,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T8.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL 
    end) as FOOTER_URL
FROM
    application T3
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId        
        LEFT OUTER JOIN
    prog_batch_seat_config T9 on T9.id = T7.progBatchSeatConfigId
        LEFT OUTER JOIN
    batches T10 on T10.id = T9.programBatchId
        LEFT OUTER JOIN
    mode_of_delivery T11 on T11.id = T10.modeOfDeliveryId
        LEFT OUTER JOIN
    programs T12 ON T12.id = T7.programId        
        LEFT JOIN
    seat_types T18 on T18.id = T9.seatTypeId
        LEFT JOIN
    users T19 on T19.id = T3.applicationOwner
        LEFT JOIN
    staffs T20 on T20.userId = T3.applicationOwner
        LEFT JOIN
    persons T21 on T21.id = T20.personId
        LEFT OUTER JOIN    
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T3.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "applicationOwnerEmail",
            "resultKey": "APPLICATION_OWNER_EMAIL",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "applicationOwnerFirstName",
            "resultKey": "APPLICATION_OWNER_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "applicationOwnerLastName",
            "resultKey": "APPLICATION_OWNER_LAST_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "applicationOwnerMobileCode",
            "resultKey": "APPLICATION_OWNER_MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "applicationOwnerMobileNumber",
            "resultKey": "APPLICATION_OWNER_MOBILE_NO",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 10            
        },
        {
            "id": 12,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "batchPrintName",
            "resultKey": "BATCH_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "seatType",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 15            
        },        
        {
            "id": 17,
            "value": "applicationReAssignDate",
            "resultKey": "APPLICATION_RE_ASSIGN_DATE",
            "displayCode": "",
            "displayOrder": 16            
        },
        {   
            "id": 18,
            "value": "applicationReAssignRemark",
            "resultKey": "APPLICATION_RE_ASSIGN_REMARK",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "applicationStatus",
            "resultKey": "APPLICATION_STATUS",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "offerStatus",
            "resultKey": "OFFER_STATUS",
            "displayCode": "",
            "displayOrder": 19
        },
        {
            "id": 21,
            "value": "applicationDate",
            "resultKey": "APPLICATION_DATE",
            "displayCode": "",
            "displayOrder": 20
        },
        {
            "id": 22,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 21
        },
        {
            "id": 23,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 22
        },
        {
            "id": 24,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 23
        }
    ]
}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICATION_RE_ASSIGN_APPLICANT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='Application Re-Assign Applicant');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_RE_ASSIGN_APPLICANT_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Application Reassign TSM',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Application Reassign TSM',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Application Re-Assignment','<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
        <tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>,</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Your Application was assigned to $recipientData[&quot;APPLICATION_OWNER_FIRST_NAME&quot;] $recipientData[&quot;APPLICATION_OWNER_LAST_NAME&quot;].<br/>
            Please call any admission related queries $recipientData[&quot;APPLICATION_OWNER_MOBILE_NO&quot;].<br/>
            Payment and login related queries, please call M.Balamurugan - IT Team - 9944552655.
            </p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">$recipientData[&quot;APPLICATION_RE_ASSIGN_REMARK&quot;]</p>
            </td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:12px;">
            <td style="padding:0px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Regards,</p>
            </td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"], Your Application was assigned to $recipientData["APPLICATION_OWNER_FIRST_NAME"] $recipientData["APPLICATION_OWNER_LAST_NAME"]. Please call any admission related queries $recipientData["APPLICATION_OWNER_MOBILE_NO"]. Payment and login related queries, please call M.Balamurugan - IT Team - 9944552655. $recipientData["APPLICATION_RE_ASSIGN_REMARK"]. Regards,');

-- End Messaging for APPLICATION_RE_ASSIGN Event